/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj.asistente.compras.valores;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.modelo.ModeloValores;
import ec.gob.sri.dimm.data.impl.UtilCatalogosATS;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.joda.time.LocalDate;

public class ModeloValoresFormaPago
implements ModeloValores {
    private boolean inicializado;
    private final Map<String, ElementoNombreValor<String>> formasPago = new TreeMap<String, ElementoNombreValor<String>>();
    private LocalDate fechaAnexo;

    public ModeloValoresFormaPago(LocalDate fechaAnexo) {
        this.fechaAnexo = fechaAnexo;
    }

    public void inicializar() {
        if (!this.inicializado) {
            this.cargarFormasPago();
            this.inicializado = true;
        }
    }

    private void cargarFormasPago() {
        this.formasPago.clear();
        Map formas = UtilCatalogosATS.crearInstancia().obtenerFormasDePago(this.fechaAnexo);
        for (Map.Entry item : formas.entrySet()) {
            this.formasPago.put((String)item.getKey(), (ElementoNombreValor<String>)new ElementoNombreValor((String)item.getValue(), (Object)((String)item.getKey())));
        }
    }

    public List<ElementoNombreValor<String>> getFormasPago() {
        return new ArrayList<ElementoNombreValor<String>>(this.formasPago.values());
    }

    public ElementoNombreValor<String> obtenerFormaDePago(String formaPago) {
        return StringUtil.isNullOrEmpty((String)formaPago) ? null : this.formasPago.get(formaPago);
    }
}

